document.getElementById('apiForm').addEventListener('submit', function(event) {
    event.preventDefault(); // Evitar envío del formulario

    var form = document.getElementById('apiForm');
    var formData = new FormData(form);

    fetch('api.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        var responseDiv = document.getElementById('response');
        responseDiv.textContent = JSON.stringify(data, null, 2);
    })
    .catch(error => console.error(error));
});
