<?php
header('Content-Type: application/json');
require("./lib/function.php");

if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
} else {
    $ip = $_SERVER['REMOTE_ADDR'];
}
// Check if required parameters are set and not empty
$requiredParameters = ['token', 'c', 'p', 'a', 'u', 'o'];

foreach ($requiredParameters as $param) {
    if (!isset($_REQUEST[$param]) || empty($_REQUEST[$param])) {
        enviarNotificacionReporte($ip, $param);
            
        
        echo json_encode(array('status' => 'error', 'response' => 'Missing or empty parameter: ' . $param));
        exit;
    }
}

$token = $_REQUEST['token'];
$creditos = base64_decode($_REQUEST['c']);
$creditosa = base64_decode($_REQUEST['ca']);
$plataforma = base64_decode($_REQUEST['p']);
$userAdmin = base64_decode($_REQUEST['a']);
$user = base64_decode($_REQUEST['u']);
$observacion = base64_decode($_REQUEST['o']);
$tipo = base64_decode($_REQUEST['t']);
$validate = verificaToken($token);

if ($validate == 'success') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $notificacion = guardarynotificar($userAdmin, $user, $plataforma, $creditos,$creditosa, $observacion, $tipo);
        if ($notificacion == 'success') {
            echo json_encode(array('status' => 'success', 'response' => 'notificado'));
        } else {
            echo json_encode(array('status' => 'error', 'response' => 'revisar'));
        }
    } else {
        echo json_encode(array('status' => 'error', 'response' => 'metodo invalido'));
    }
} else {
    echo json_encode(array('status' => 'error', 'response' => 'token invalido'));
}
?>